{********************************************
; File: MiscTool.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT MISCTOOL;
INTERFACE
USES TYPES;
CONST

{ Error codes }
badInputErr = $0301;  { bad input parameter }
noDevParamErr = $0302;  { no device for input parameter }
taskInstlErr = $0303;  { task already installed error }
noSigTaskErr = $0304;  { no signature in task header }
queueDmgdErr = $0305;  { queue has been damaged error }
taskNtFdErr = $0306;  { task was not found error }
firmTaskErr = $0307;  { firmware task was unsuccessful }
hbQueueBadErr = $0308;  { heartbeat queue damaged }
unCnctdDevErr = $0309;  { attempted to dispatch to unconnected device }
idTagNtAvlErr = $030B;  { ID tag not available }
notInList = $0380;
invalidTag = $0381;  { correct signature value not found in header }
alreadyInQueue = $0382;

{ System Fail Codes }
pdosUnClmdIntErr = $0001;  { ProDOS unclaimed interrupt error }
divByZeroErr = $0004;  { divide by zero error }
pdosVCBErr = $000A;  { ProDOS VCB unusable }
pdosFCBErr = $000B;  { ProDOS FCB unusable }
pdosBlk0Err = $000C;  { ProDOS block zero allocated illegally }
pdosIntShdwErr = $000D;  { ProDOS interrupt w/ shadowing off }
segLoader1Err = $0015;  { segment loader error }
sPackage0Err = $0017;  { can't load a package }
package1Err = $0018;  { can't load a package }
package2Err = $0019;  { can't load a package }
package3Err = $001A;  { can't load a package }
package4Err = $001B;  { can't load a package }
package5Err = $001C;  { can't load a package }
package6Err = $001D;  { can't load a package }
package7Err = $001E;  { can't load a package }
package8Err = $0020;  { can't load a package }
package9Err = $0021;  { can't load a package }
package10Err = $0022;  { can't load a package }
package11Err = $0023;  { can't load a package }
package12Err = $0024;  { can't load a package }
outOfMemErr = $0025;  { out of memory error }
segLoader2Err = $0026;  { segment loader error }
fMapTrshdErr = $0027;  { file map trashed }
stkOvrFlwErr = $0028;  { stack overflow error }
psInstDiskErr = $0030;  { Please Insert Disk (file manager alert) }
memMgr1Err = $0032;  { memory manager error }
memMgr2Err = $0033;  { memory manager error }
memMgr3Err = $0034;  { memory manager error }
memMgr4Err = $0035;  { memory manager error }
memMgr5Err = $0036;  { memory manager error }
memMgr6Err = $0037;  { memory manager error }
memMgr7Err = $0038;  { memory manager error }
memMgr8Err = $0039;  { memory manager error }
memMgr9Err = $003A;  { memory manager error }
memMgr10Err = $003B;  { memory manager error }
memMgr11Err = $003C;  { memory manager error }
memMgr12Err = $003D;  { memory manager error }
memMgr13Err = $003E;  { memory manager error }
memMgr14Err = $003F;  { memory manager error }
memMgr15Err = $0040;  { memory manager error }
memMgr16Err = $0041;  { memory manager error }
memMgr17Err = $0042;  { memory manager error }
memMgr18Err = $0043;  { memory manager error }
memMgr19Err = $0044;  { memory manager error }
memMgr20Err = $0045;  { memory manager error }
memMgr21Err = $0046;  { memory manager error }
memMgr22Err = $0047;  { memory manager error }
memMgr23Err = $0048;  { memory manager error }
memMgr24Err = $0049;  { memory manager error }
memMgr25Err = $004A;  { memory manager error }
memMgr26Err = $004B;  { memory manager error }
memMgr27Err = $004C;  { memory manager error }
memMgr28Err = $004D;  { memory manager error }
memMgr29Err = $004E;  { memory manager error }
memMgr30Err = $004F;  { memory manager error }
memMgr31Err = $0050;  { memory manager error }
memMgr32Err = $0051;  { memory manager error }
memMgr33Err = $0052;  { memory manager error }
memMgr34Err = $0053;  { memory manager error }
stupVolMntErr = $0100;  { can't mount system startup volume }

{ Battery Ram Parameter Reference Numbers }
p1PrntModem = $0000;
p1LineLnth = $0001;
p1DelLine = $0002;
p1AddLine = $0003;
p1Echo = $0004;
p1Buffer = $0005;
p1Baud = $0006;
p1DtStpBits = $0007;
p1Parity = $0008;
p1DCDHndShk = $0009;
p1DSRHndShk = $000A;
p1XnfHndShk = $000B;
p2PrntModem = $000C;
p2LineLnth = $000D;
p2DelLine = $000E;
p2AddLine = $000F;
p2Echo = $0010;
p2Buffer = $0011;
p2Baud = $0012;
p2DtStpBits = $0013;
p2Parity = $0014;
p2DCDHndShk = $0015;
p2DSRHndShk = $0016;
p2XnfHndShk = $0017;
dspColMono = $0018;
dsp40or80 = $0019;
dspTxtColor = $001A;
dspBckColor = $001B;
dspBrdColor = $001C;
hrtz50or60 = $001D;
userVolume = $001E;
bellVolume = $001F;
sysSpeed = $0020;
slt1intExt = $0021;
slt2intExt = $0022;
slt3intExt = $0023;
slt4intExt = $0024;
slt5intExt = $0025;
slt6intExt = $0026;
slt7intExt = $0027;
startupSlt = $0028;
txtDspLang = $0029;
kyBdLang = $002A;
kyBdBuffer = $002B;
kyBdRepSpd = $002C;
kyBdRepDel = $002D;
dblClkTime = $002E;
flashRate = $002F;
shftCpsLCas = $0030;
fstSpDelKey = $0031;
dualSpeed = $0032;
hiMouseRes = $0033;
dateFormat = $0034;
clockFormat = $0035;
rdMinRam = $0036;
rdMaxRam = $0037;
langCount = $0038;
lang1 = $0039;
lang2 = $003A;
lang3 = $003B;
lang4 = $003C;
lang5 = $003D;
lang6 = $003E;
lang7 = $003F;
lang8 = $0040;
layoutCount = $0041;
layout1 = $0042;
layout2 = $0043;
layout3 = $0044;
layout4 = $0045;
layout5 = $0046;
layout6 = $0047;
layout7 = $0048;
layout8 = $0049;
layout9 = $004A;
layout10 = $004B;
layout11 = $004C;
layout12 = $004D;
layout13 = $004E;
layout14 = $004F;
layout15 = $0050;
layout16 = $0051;
aTalkNodeNo = $0080;

{ GetAddr Parameter Reference Numbers }
irqIntFlag = $0000;
irqDataReg = $0001;
irqSerial1 = $0002;
irqSerial2 = $0003;
irqAplTlkHi = $0004;
tickCnt = $0005;
irqVolume = $0006;
irqActive = $0007;
irqSndData = $0008;
brkVar = $0009;
evMgrData = $000A;
mouseSlot = $000B;
mouseClamps = $000C;
absClamps = $000D;
sccIntFlag = $000E;

{ Hardware Interrupt Status Numbers }
extVGCInt = $01;  { Returned by GetIRQEnable }
scanLineInt = $02;  { Returned by GetIRQEnable }
adbDataInt = $04;  { Returned by GetIRQEnable }
ADTBDataInt = $04;  { maintained for compatiblity with old interfaces }
oneSecInt = $10;  { Returned by GetIRQEnable }
quartSecInt = $20;  { Returned by GetIRQEnable }
vbInt = $40;  { Returned by GetIRQEnable }
kbdInt = $80;  { Returned by GetIRQEnable }

{ Interrupt Reference Numbers }
kybdEnable = $0000;  { Parameter to IntSource }
kybdDisable = $0001;  { Parameter to IntSource }
vblEnable = $0002;  { Parameter to IntSource }
vblDisable = $0003;  { Parameter to IntSource }
qSecEnable = $0004;  { Parameter to IntSource }
qSecDisable = $0005;  { Parameter to IntSource }
oSecEnable = $0006;  { Parameter to IntSource }
oSecDisable = $0007;  { Parameter to IntSource }
adbEnable = $000A;  { Parameter to IntSource }
adbDisable = $000B;  { Parameter to IntSource }
scLnEnable = $000C;  { Parameter to IntSource }
scLnDisable = $000D;  { Parameter to IntSource }
exVCGEnable = $000E;  { Parameter to IntSource }
exVCGDisable = $000F;  { Parameter to IntSource }

{ Mouse Mode Values }
mouseOff = $0000;
transparent = $0001;
transParnt = $0001;  { (old name) }
moveIntrpt = $0003;
bttnIntrpt = $0005;
bttnOrMove = $0007;
mouseOffVI = $0008;
transParntVI = $0009;  { (old name) }
transparentVI = $0009;
moveIntrptVI = $000B;
bttnIntrptVI = $000D;
bttnOrMoveVI = $000F;

{ Vector Reference Numbers }
toolLoc1 = $0000;
toolLoc2 = $0001;
usrTLoc1 = $0002;
usrTLoc2 = $0003;
intrptMgr = $0004;
copMgr = $0005;
abortMgr = $0006;
_sysFailMgr = $0007;
aTalkIntHnd = $0008;
sccIntHnd = $0009;
scLnIntHnd = $000A;
sndIntHnd = $000B;
vblIntHnd = $000C;
mouseIntHnd = $000D;
qSecIntHnd = $000E;
kybdIntHnd = $000F;
adbRBIHnd = $0010;
adbSRQHnd = $0011;
deskAccHnd = $0012;
flshBufHnd = $0013;
kybdMicHnd = $0014;
oneSecHnd = $0015;
extVCGHnd = $0016;
otherIntHnd = $0017;
crsrUpdtHnd = $0018;
incBsyFlag = $0019;
decBsyFlag = $001A;
bellVector = $001B;
breakVector = $001C;
traceVector = $001D;
stepVector = $001E;
ctlYVector = $0028;
proDOSVector = $002A;
proDOSVctr = $002A;  { for backward compatibility }
osVector = $002B;
msgPtrVector = $002C;
msgPtrVctr = $002C;  { for backward compatibility }
memMoverVector = $0080;
sysSpeedVector = $0081;
slotArbiterVector = $0082;
hiInterruptVector = $0086;
midiInterruptVector = $0087;

TYPE
ClampRecHndl = ^ClampRecPtr;
ClampRecPtr = ^ClampRec;
ClampRec = RECORD
    yMaxClamp : Integer;
    yMinClamp : Integer;
    xMaxClamp : Integer;
    xMinClamp : Integer;
END;
FWRecHndl = ^FWRecPtr;
FWRecPtr = ^FWRec;
FWRec = RECORD
    yRegExit : Integer;
    xRegExit : Integer;
    aRegExit : Integer;
    status : Integer;
END;
MouseRecHndl = ^MouseRecPtr;
MouseRecPtr = ^MouseRec;
MouseRec = PACKED RECORD
    mouseMode : Byte;
    mouseStatus : Byte;
    yPos : Integer;
    xPos : Integer;
END;
InterruptStateRecHndl = ^InterruptStateRecPtr;
InterruptStateRecPtr = ^InterruptStateRec;
InterruptStateRec = PACKED RECORD
    irq_A : Integer;
    irq_X : Integer;
    irq_Y : Integer;
    irq_S : Integer;
    irq_D : Integer;
    irq_P : Byte;
    irq_DB : Byte;
    irq_e : Byte;
    irq_K : Byte;
    irq_PC : Integer;
    irq_state : Byte;
    irq_shadow : Integer;
    irq_mslot : Byte;
END;
QueueHeaderRecPtr = ^QueueHeaderRec;
QueueHeaderRec = RECORD
    qNext : QueueHeaderRecPtr;
    reserved : Integer;
    signature : Integer; { Validates header - must be $A55A  }
END;
PROCEDURE AddToQueue ( newEntryPtr:Ptr; headerPtr:Ptr)  ;
PROCEDURE ClampMouse ( xMinClamp:Integer; xMaxClamp:Integer; yMinClamp:Integer; yMaxClamp:Integer)  ;
PROCEDURE ClearMouse   ;
PROCEDURE ClrHeartBeat   ;
PROCEDURE DelHeartBeat ( taskPtr:Ptr)  ;
PROCEDURE DeleteFromQueue ( entryPtr:Ptr; headerPtr:Ptr)  ;
PROCEDURE DeleteID ( idTag:Integer)  ;
FUNCTION FWEntry ( aRegValue:Integer; xRegValue:Integer; yRegValue:Integer; eModeEntryPt:Integer) : FWRec ;
FUNCTION GetAbsClamp  : ClampRec ;
FUNCTION GetAddr ( refNum:Integer) : Ptr ;
FUNCTION GetCodeResConverter  : ProcPtr ;
FUNCTION GetIRQEnable  : Integer ;
FUNCTION GetIntStateRecSize  : Integer ;
PROCEDURE GetInterruptState (VAR iStateRec:InterruptStateRec; bytesDesired:Integer)  ;
FUNCTION GetMouseClamp  : ClampRec ;
FUNCTION GetNewID ( idTag:Integer) : Integer ;
FUNCTION GetRomResource  : Ptr ;
FUNCTION GetTick  : Longint ;
FUNCTION GetVector ( vectorRefNum:Integer) : Ptr ;
PROCEDURE HomeMouse   ;
PROCEDURE InitMouse ( mouseSlot:Integer)  ;
PROCEDURE IntSource ( srcRefNum:Integer)  ;
PROCEDURE MTBootInit   ;
PROCEDURE MTReset   ;
PROCEDURE MTShutDown   ;
PROCEDURE MTStartUp   ;
FUNCTION MTStatus  : Boolean ;
FUNCTION MTVersion  : Integer ;
FUNCTION Munger ( destPtr:Ptr; destLenPtr:IntPtr; targPtr:Ptr; targLen:Integer; replPtr:Ptr; replLen:Integer; padPtr:Ptr) : Integer ;
FUNCTION PackBytes (VAR srcBuffer:Ptr;VAR srcSize:Integer; dstBuffer:Ptr; dstSize:Integer) : Integer ;
PROCEDURE PosMouse ( xPos:Integer; yPos:Integer)  ;
PROCEDURE ReadAsciiTime ( bufferPtr:Ptr)  ;
FUNCTION ReadBParam ( paramRefNum:Integer) : Integer ;
PROCEDURE ReadBRam ( bufferPtr:Ptr)  ;
FUNCTION ReadMouse  : MouseRec ;
FUNCTION ReadMouse2  : MouseRec ;
FUNCTION ReadTimeHex  : TimeRec ;
PROCEDURE ReleaseRomResource   ;
FUNCTION ServeMouse  : Integer ;
PROCEDURE SetAbsClamp ( xMinClamp:Integer; xMaxClamp:Integer; yMinClamp:Integer; yMaxClamp:Integer)  ;
PROCEDURE SetHeartBeat ( taskPtr:Ptr)  ;
PROCEDURE SetInterruptState ( iStateRec:InterruptStateRec; bytesDesired:Integer)  ;
PROCEDURE SetMouse ( mouseMode:Integer)  ;
PROCEDURE SetVector ( vectorRefNum:Integer; vectorPtr:Ptr)  ;
PROCEDURE StatusID ( idTag:Integer)  ;
PROCEDURE SysBeep   ;
PROCEDURE SysFailMgr ( errorCode:Integer; str:Str255)  ;
FUNCTION UnPackBytes ( srcBuffer:Ptr; srcSize:Integer;VAR dstBuffer:Ptr;VAR dstSize:Integer) : Integer ;
PROCEDURE WriteBParam ( theData:Integer; paramRefNum:Integer)  ;
PROCEDURE WriteBRam ( bufferPtr:Ptr)  ;
PROCEDURE WriteTimeHex ( month:Byte; day:Byte; curYear:Byte; hour:Byte; minute:Byte; second:Byte)  ;
IMPLEMENTATION
END.
